/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil.security.base;

import filenet.vw.ntutil.EventLog;
import filenet.vw.ntutil.security.NTSecurity;
import filenet.vw.ntutil.security.base.IVWNTSSPIServer;
import filenet.vw.ntutil.security.base.IVWNTUtil;
import filenet.vw.ntutil.security.base.NTSecurityToken;
import filenet.vw.ntutil.security.base.NativeSSPIPackage;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.security.base.SSPIServer;
import filenet.vw.ntutil.trace;
import filenet.vw.sysutils.VWRegistryTool;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class VWNTUtil
extends UnicastRemoteObject
implements IVWNTUtil {
    public synchronized IVWNTSSPIServer getSSPIServer() throws RemoteException, Exception {
        if (NativeSSPIPackage.init()) {
            SSPIServer server = new SSPIServer();
            return server;
        }
        throw new Exception("IVWNTSSPISERVER: Unable to obtain SSPI server handle.");
    }

    public NTSecurityToken impersonateTest(SSPISecHandle svrContext) throws RemoteException, Exception {
        NTSecurityToken result = NativeSSPIPackage.impersonateContext(svrContext);
        if (result != null) {
            trace.println("VWNTUtil.impersonateTest got " + result.toString());
        }
        NativeSSPIPackage.revertContext(svrContext);
        return result;
    }

    public static void bindService(String theName, int thePort, VWNTUtil theObject) throws Exception {
        EventLog log = new EventLog();
        try {
            trace.println("Entering VWNTUtil.bindService " + theName + " @ " + Integer.toString(thePort));
            VWRegistryTool.rebind(theName, theObject, thePort);
            String s = theName + " bound to port: " + Integer.toString(thePort);
            log.LogEvent(0x60000001L, s, 4);
            trace.println(s);
            try {
                NTSecurity sec = new NTSecurity();
                NTSecurityToken tok = sec.getCurrentThreadToken();
                trace.println("VWNTUTIL Identity = " + tok.toString());
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            String s = "Cannot bind VWNTUtil, exception=" + e.getMessage() + ", please configure the Integeration Service via eProcess Services Administration tool to use a different port.";
            log.LogEvent(-536870910L, s, 1);
            trace.println(s);
            throw e;
        }
    }

    public static void unbindService(String theName, int thePort) {
        try {
            VWRegistryTool.unbind(theName, thePort);
            EventLog log = new EventLog();
            String s = theName + " is unbound from port: " + thePort;
            log.LogEvent(0x60000001L, s, 4);
            trace.println(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            VWNTUtil aSvc = new VWNTUtil();
            VWNTUtil.bindService("VWNTUtil", 32771, aSvc);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

